/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.impl.NoLevelsModifier;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class ClusteringModifier
extends NoLevelsModifier
implements ConditionalStatModifierHook {
    public float getPercentage(Inventory i) {
        int sizeInv = i.m_6643_();
        float current = 0.0f;
        float sum = 0.0f;
        while (sizeInv-- > 0) {
            ItemStack stackInv = i.m_8020_(sizeInv);
            if (stackInv.m_41619_() || !stackInv.m_204117_(TinkerTags.Items.MODIFIABLE)) continue;
            ToolStack toolInv = ToolStack.from((ItemStack)stackInv);
            current += (float)toolInv.getCurrentDurability();
            sum += ((Float)toolInv.getStats().get((IToolStat)ToolStats.DURABILITY)).floatValue();
        }
        return current / sum;
    }

    public void onBreakSpeed(IToolStackView tool, int level, PlayerEvent.BreakSpeed event, Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        Player player = event.getPlayer();
        Inventory inv = player.m_150109_();
        if ((double)this.getPercentage(inv) <= 0.45) {
            event.setNewSpeed(event.getNewSpeed() * (1.45f - this.getPercentage(inv)));
        }
    }

    public float getEntityDamage(IToolStackView tool, int level, ToolAttackContext context, float baseDamage, float damage) {
        Player player = context.getPlayerAttacker();
        Inventory inv = player.m_150109_();
        float percentage = this.getPercentage(inv);
        if ((double)percentage > 0.45) {
            return damage * (1.0f + percentage);
        }
        return damage;
    }

    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, TinkerHooks.CONDITIONAL_STAT);
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        Player player = (Player)living;
        Inventory inv = player.m_150109_();
        float percentage = this.getPercentage(inv);
        if ((double)percentage > 0.45) {
            if (stat == ToolStats.PROJECTILE_DAMAGE) {
                return baseValue * (1.0f + percentage);
            }
        } else if (stat == ToolStats.DRAW_SPEED) {
            return baseValue * (1.45f - percentage);
        }
        return baseValue;
    }
}

